---
Difficulty: Medium
Source: Daily-Question(POTD 26-Nov)
Tags:
    - Graph
---

# 🚀 *2924 - Find Champion II* 🧠


### **Problem Link:**  
[**LeetCode - Find Champion II**](https://leetcode.com/problems/find-champion-ii/description/?envType=daily-question&envId=2024-11-26)



## 💡 **Problem Breakdown:**

In this problem, we are given a **directed acyclic graph (DAG)** with `n` nodes (representing teams) and `m` edges. Each edge `[u, v]` indicates that **team `u` is stronger than team `v`**.

We aim to determine the **champion team**, defined as the one with **no incoming edges** (no team is stronger than it). If there is more than one such team or no such team, we return `-1`.

### Key Points:
1. **Indegree Concept:**  
   - A team with an **indegree of `0`** has no incoming edges and could be the champion.
   
2. **Uniqueness Check:**  
   - If more than one node has an indegree of `0`, there is no unique champion.

3. **Output:**  
   - Return the team with **indegree `0`** if it's unique, else return `-1`.



## 🔍 **Example Walkthrough:**

### **Example 1:**

<img src="https://github.com/user-attachments/assets/598a696f-b901-4b04-a757-37b53000f2cd" width="28%">

**Input:**  
`n = 3, edges = [[0,1],[1,2]]`  
**Output:**  
`0`  

**Explanation:**
- Team `1` is weaker than team `0`.  
- Team `2` is weaker than team `1`.  
- Team `0` has no incoming edges → Champion is `0`.


### **Example 2:**

<img src="https://github.com/user-attachments/assets/6439a1f0-6f08-4fda-b50a-89dde162e75d" width="28%">

**Input:**  
`n = 4, edges = [[0,2],[1,3],[1,2]]`  
**Output:**  
`-1`  

**Explanation:**
- Team `2` is weaker than both team `0` and team `1`.  
- Team `3` is weaker than team `1`.  
- Teams `0` and `1` both have no incoming edges → No unique champion.



### Constraints:
- `1 <= n <= 100`
- `m == edges.length`
- `0 <= m <= n * (n - 1) / 2`
- `edges[i].length == 2`
- `0 <= edge[i][j] <= n - 1`
- `edges[i][0] != edges[i][1]` 
- Each edge `[ui, vi]` satisfies `ui != vi`.
- Input is guaranteed to represent a DAG (no cycles).
- The input is generated such that if team a is stronger than team b, team b is not stronger than team a.
- The input is generated such that if team a is stronger than team b and team b is stronger than team c, then team a is stronger than team c.


## 🎯 **My Approach:**

1. **Track Indegree of Nodes:**  
   - Use an array to count the number of incoming edges for each team.
   
2. **Find Candidates:**  
   - Identify nodes with **indegree `0`**.  
   - Ensure there's only one such node.

3. **Return Result:**  
   - If there is exactly one node with indegree `0`, return it. Otherwise, return `-1`.



## 🕒 **Time Complexity:**

- **Time Complexity:** `O(m)`  
   - We iterate through the edges once to compute indegrees.  
- **Space Complexity:** `O(n)`  
   - Storage for the `indegree` array.


## 📝 **Solution Code**

## Code (C)

```c
int findChampion(int n, int** edges, int edgesSize, int* edgesColSize) {
    int* indegree = (int*)calloc(n, sizeof(int));
    if (!indegree) return -1;

    for (int i = 0; i < edgesSize; i++) {
        indegree[edges[i][1]]++;
    }

    int champion = -1;
    for (int i = 0; i < n; i++) {
        if (indegree[i] == 0) {
            if (champion != -1) {
                free(indegree);
                return -1; 
            }
            champion = i;
        }
    }

    free(indegree);
    return champion;
}
```


## Code (C++)

```cpp
class Solution {
public:
    int findChampion(int n, vector<vector<int>>& edges) {
        vector<int> indegree(n, 0);

        for (auto& edge : edges) {
            indegree[edge[1]]++;
        }

        int champion = -1;
        for (int i = 0; i < n; i++) {
            if (indegree[i] == 0) {
                if (champion != -1) {
                    return -1; 
                }
                champion = i;
            }
        }

        return champion;
    }
};
```


## Code (Java)

```java
class Solution {
    public int findChampion(int n, int[][] edges) {
        int[] indegree = new int[n];

        for (int[] edge : edges) {
            indegree[edge[1]]++;
        }

        int champion = -1;
        for (int i = 0; i < n; i++) {
            if (indegree[i] == 0) {
                if (champion != -1) {
                    return -1;
                }
                champion = i;
            }
        }

        return champion;
    }
}
```


## Code (Python)

```python3
class Solution:
    def findChampion(self, n: int, edges: List[List[int]]) -> int:
        indegree = [0] * n
        
        for _, v in edges:
            indegree[v] += 1
        
        champion = -1
        for i in range(n):
            if indegree[i] == 0:
                if champion != -1:  
                    return -1
                champion = i
        
        return champion 
```


## Code (Rust)

```rust
impl Solution {
    pub fn find_champion(n: i32, edges: Vec<Vec<i32>>) -> i32 {
        let mut indegree = std::collections::HashMap::new();

        for edge in edges {
            *indegree.entry(edge[1]).or_insert(0) += 1;
        }

        let mut champion = -1;

        for i in 0..n {
            if indegree.get(&i).copied().unwrap_or(0) == 0 {
                if champion != -1 {
                    return -1; 
                }
                champion = i;
            }
        }

        champion
    }
}
```

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Conclusion:**
- **Efficiently calculates the champion** by leveraging the DAG properties.  
- The solution is simple and adheres to the constraints, ensuring correctness and optimal performance.

# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
